#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct  tacka {
    long long x, y;

    
    bool operator<(const tacka& druga) const {
        return (x == druga.x) ? (y < druga.y) : (x < druga.x);
    }
};


long long proizvodVektora(const tacka& O, const tacka& A, const tacka& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

double povrsinaPoligona(const vector<tacka>& tacke) {
    double povrsina = 0;
    int n = tacke.size();
   
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        povrsina += tacke[i].x * tacke[j].y;
        povrsina -= tacke[j].x * tacke[i].y;
    }
    return abs(povrsina) / 2.0;
}

vector<tacka> konveksnaOmotac(vector<tacka>& tacke) {
    sort(tacke.begin(), tacke.end());
    vector<tacka> donja, gornja;

    for (const auto& p : tacke) {
        while (donja.size() >= 2 && proizvodVektora(donja[donja.size() - 2], donja.back(), p) <= 0) {
            donja.pop_back();
        }
        donja.push_back(p);
    }

    for (int i = tacke.size() - 1; i >= 0; i--) {
        const auto& p = tacke[i];
        while (gornja.size() >= 2 && proizvodVektora(gornja[gornja.size() - 2], gornja.back(), p) <= 0) {
            gornja.pop_back(); 
        }
        gornja.push_back(p);
    }

    gornja.pop_back();
    donja.pop_back();

    donja.insert(donja.end(), gornja.begin(), gornja.end());
    return donja;
}

int main() {
    int N;
    cin >> N;
    vector<tacka> tacke(N);

    for (int i = 0; i < N; i++) {
        cin >> tacke[i].x >> tacke[i].y; 
    }

    double minimalnaPovrsina = 1e18; 

    for (int i = 0; i < N; i++) {
        vector<tacka> preostaleTacke;
        for (int j = 0; j < N; j++) {
            if (j != i) {
                preostaleTacke.push_back(tacke[j]);
            }
        }

        vector<tacka> omota = konveksnaOmotac(preostaleTacke); 
        double povrsina = povrsinaPoligona(omota);
        minimalnaPovrsina = min(minimalnaPovrsina, povrsina); 
    }

    cout << static_cast<long long>(minimalnaPovrsina) << endl; 
    return 0;
}